function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
% function T = dynamic_g1_tt(T, y, x, params, steady_state, it_)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double  vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double  vector of endogenous variables in the order stored
%                                                    in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double  matrix of exogenous variables (in declaration order)
%                                                    for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double  vector of steady state values
%   params        [M_.param_nbr by 1]        double  vector of parameter values in declaration order
%   it_           scalar                     double  time period for exogenous variables for which
%                                                    to evaluate the model
%
% Output:
%   T           [#temp variables by 1]       double  vector of temporary terms
%

assert(length(T) >= 282);

T = World_Economy_Cartel_cheaters.dynamic_resid_tt(T, y, x, params, steady_state, it_);

T(130) = exp(y(30))*T(32)*T(104);
T(131) = T(34)*y(28)*(-(exp(y(30))*T(24)*exp((-y(60)))))+T(36)+T(35)+T(34)*y(25)*(-(exp(y(30))*T(24)));
T(132) = T(34)*y(26)*(-(T(24)*exp(y(30))*(-exp(y(14)-y(60)))))+T(34)*y(28)*(-(exp(y(30))*T(24)*(-exp((-y(60))))));
T(133) = (-(T(23)*exp(y(105))*exp(y(43)-y(117))));
T(134) = (exp(y(31))+exp(y(33)))*(exp(y(31))+exp(y(33)));
T(135) = (exp(y(31))*(exp(y(31))+exp(y(33)))-exp(y(31))*exp(y(31)))/T(134);
T(136) = (-(exp(y(31))*exp(y(33))))/T(134);
T(137) = (exp(y(33))*(exp(y(31))+exp(y(33)))-exp(y(33))*exp(y(33)))/T(134);
T(138) = (T(32)+exp(y(35)))*(T(32)+exp(y(35)));
T(139) = (T(32)*(T(32)+exp(y(35)))-T(32)*T(32))/T(138);
T(140) = (-(T(32)*exp(y(35))))/T(138);
T(141) = (exp(y(35))*(T(32)+exp(y(35)))-exp(y(35))*exp(y(35)))/T(138);
T(142) = T(119)+y(85)*T(122)+y(73)*exp(y(8))*params(6)*exp(params(5)*(y(15)-y(60)))*(-params(5));
T(143) = (-(exp(y(8))*exp((-y(60)))*exp(y(15))));
T(144) = T(45)+params(23)*y(122)*exp(y(38))*params(6)*params(5)*exp(params(5)*y(45))+T(61);
T(145) = T(117)+T(121)+y(73)*exp(y(10))*params(6)*exp(params(5)*(y(14)-y(60)))*(-params(5));
T(146) = (-(exp(y(10))*exp((-y(60)))*exp(y(14))));
T(147) = T(47)+params(23)*y(122)*exp(y(39))*params(6)*params(5)*exp(params(5)*(y(43)-y(117)))+T(56);
T(148) = exp(y(30))*exp(y(14)-y(60))+y(50)*(-exp(y(14)-y(60)));
T(149) = T(34)*y(28)*T(24)*params(6)*params(5)*(params(5)-1)*exp((y(14)-y(60))*(params(5)-1))+T(34)*y(26)*(-(T(24)*(T(148)-params(6)*params(5)*exp(params(5)*(y(14)-y(60))))));
T(150) = (-(exp(y(10))*(-(exp((-y(60)))*exp(y(14))))));
T(151) = (-(T(23)*(T(53)-params(6)*params(5)*params(5)*exp(params(5)*(y(43)-y(117))))));
T(152) = y(80)*T(151);
T(153) = T(119)+y(85)*T(122)+y(73)*exp(y(8))*params(6)*(-params(5))*params(5)*exp(params(5)*(y(15)-y(60)));
T(154) = (-(exp(y(8))*(-(exp((-y(60)))*exp(y(15))))));
T(155) = T(43)+T(57)+params(23)*y(122)*exp(y(37))*params(6)*params(5)*params(5)*exp(params(5)*(y(44)-y(117)));
T(156) = T(34)*y(25)*T(24)*params(6)*params(5)*(params(5)-1)*exp(y(16)*(params(5)-1))+T(34)*y(23)*(-(T(24)*(exp(y(30))*exp(y(16))+y(47)*(-exp(y(16)))-params(6)*params(5)*exp(params(5)*y(16)))));
T(157) = (-(T(23)*(exp(y(45))*exp(y(105))+y(106)*(-exp(y(45)))-params(6)*params(5)*params(5)*exp(params(5)*y(45)))));
T(158) = T(8)*getPowerDeriv(T(8),T(13),2);
T(159) = T(8)*T(158);
T(160) = T(62)+T(159);
T(161) = T(8)*getPowerDeriv(T(8),T(1),2);
T(162) = T(8)*T(161);
T(163) = T(63)+T(162);
T(164) = params(11)*T(163);
T(165) = getPowerDeriv(T(9),T(10),2);
T(166) = exp(y(108))*getPowerDeriv(exp(y(108)),T(1),1);
T(167) = getPowerDeriv(T(76),T(10),2);
T(168) = T(34)*y(26)*(-(T(24)*(1-exp(y(14)-y(60)))))+T(34)*y(28)*T(24)*exp((-y(60)));
T(169) = T(34)*y(26)*(-(T(24)*exp(y(14)-y(60))))+T(34)*y(28)*T(24)*(-exp((-y(60))));
T(170) = exp(y(52))*getPowerDeriv(exp(y(52)),T(11),2);
T(171) = exp(y(52))*T(170);
T(172) = T(65)+T(171);
T(173) = y(71)*(-(T(19)*T(16)*T(66)*T(94)+T(5)*T(19)*T(66)*T(96)))+y(70)*(-(T(17)*T(3)*T(67)*T(96)+T(3)*T(16)*T(67)*T(98)));
T(174) = (-(T(5)*T(19)*T(16)*T(65)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(59))));
T(175) = (-(T(17)*T(3)*T(16)*T(65)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(59))));
T(176) = y(71)*T(174)+y(70)*T(175);
T(177) = exp(y(111))*getPowerDeriv(exp(y(111)),T(11),1);
T(178) = (1-params(11))*(1-params(3))*exp(T(1)*y(116))*T(177);
T(179) = (-(T(69)*(T(84)*T(83)*(1-params(11))*params(3)*exp(T(1)*y(116))*T(177)+T(86)*T(81)*(1-params(11))*params(3)*exp(T(1)*y(116))*T(177))));
T(180) = exp(y(18))*getPowerDeriv(exp(y(18)),params(3),1);
T(181) = T(5)*T(180);
T(182) = T(2)*T(100)*T(181);
T(183) = exp(y(18))*getPowerDeriv(exp(y(18)),params(3)-1,1);
T(184) = (-(T(5)*(T(16)*T(66)*T(183)+T(19)*T(66)*T(95)*T(181))));
T(185) = T(16)*T(67)*T(180)+T(3)*T(67)*T(95)*T(181);
T(186) = getPowerDeriv(T(6),T(13),2);
T(187) = T(95)*T(94)*T(180)+T(3)*T(94)*T(181)*T(186);
T(188) = T(15)*T(16)*T(180)+T(3)*T(15)*T(95)*T(181);
T(189) = getPowerDeriv(T(6),T(1),2);
T(190) = T(2)*(T(100)*T(94)*T(180)+T(3)*T(94)*T(181)*T(189));
T(191) = (-(exp(y(54)*(1-params(3)))*T(1)*exp(T(1)*y(59))*params(3)*exp(y(18)*params(3))));
T(192) = T(16)*T(108)*T(183)+T(19)*T(108)*T(95)*T(181);
T(193) = T(16)*T(109)*T(180)+T(3)*T(109)*T(95)*T(181);
T(194) = T(20)*getPowerDeriv(T(20),params(3),2);
T(195) = T(20)*T(194);
T(196) = T(70)+T(195);
T(197) = getPowerDeriv(T(72),T(1),2);
T(198) = T(68)*(T(73)*T(69)*T(196)+T(69)*T(70)*T(69)*T(70)*T(197));
T(199) = getPowerDeriv(T(72),T(13),2);
T(200) = T(82)*T(69)*T(196)+T(69)*T(70)*T(69)*T(70)*T(199);
T(201) = T(20)*getPowerDeriv(T(20),params(3)-1,2);
T(202) = T(20)*T(201);
T(203) = T(86)+T(202);
T(204) = exp(y(19))*getPowerDeriv(exp(y(19)),1+params(8),1);
T(205) = (-(params(9)*T(204)/(1+params(8))));
T(206) = getPowerDeriv(T(27),(-params(15)),1);
T(207) = T(205)*T(206);
T(208) = (-((-(params(1)*T(91)*T(207)))/(T(28)*T(28))));
T(209) = (-((-(params(1)*T(104)*T(207)))/(T(28)*T(28))));
T(210) = T(4)*getPowerDeriv(T(4),1+params(8),2);
T(211) = T(4)*T(210);
T(212) = T(88)+T(211);
T(213) = (-(params(9)*T(212)/(1+params(8))));
T(214) = getPowerDeriv(T(25),(-params(15)),2);
T(215) = T(90)*T(213)+T(89)*T(89)*T(214);
T(216) = T(4)*getPowerDeriv(T(4),1-params(3),2);
T(217) = T(4)*T(216);
T(218) = T(94)+T(217);
T(219) = T(95)*T(3)*T(218)+T(3)*T(94)*T(3)*T(94)*T(186);
T(220) = (-(T(94)*T(19)*T(18)*T(96)+T(16)*T(18)*T(19)*T(218)+T(94)*T(19)*T(18)*T(96)+T(5)*T(19)*T(18)*T(219)));
T(221) = T(4)*getPowerDeriv(T(4),(-params(3)),2);
T(222) = T(4)*T(221);
T(223) = T(98)+T(222);
T(224) = (-(T(3)*T(15)*T(96)*T(98)+T(17)*T(3)*T(15)*T(219)+T(3)*T(15)*T(96)*T(98)+T(3)*T(15)*T(16)*T(223)));
T(225) = T(2)*(T(100)*T(3)*T(218)+T(3)*T(94)*T(3)*T(94)*T(189));
T(226) = T(26)*T(26)*T(26)*T(26);
T(227) = (-((T(26)*T(26)*(-(T(103)*T(215)))-(-(T(91)*T(103)))*(T(26)*T(91)+T(26)*T(91)))/T(226)));
T(228) = exp(y(55))*T(89)*T(214);
T(229) = T(26)*T(26)*(-(T(103)*T(228)))-(-(T(103)*T(104)))*(T(26)*T(91)+T(26)*T(91));
T(230) = (-(T(94)*T(19)*T(16)*T(108)+T(5)*T(19)*T(96)*T(108)));
T(231) = y(71)*T(230);
T(232) = y(70)*(-(T(98)*T(3)*T(16)*T(109)+T(17)*T(3)*T(96)*T(109)));
T(233) = T(3)*T(94)*T(100)*T(110);
T(234) = T(91)*T(114);
T(235) = exp(y(112))*getPowerDeriv(exp(y(112)),1-params(3),1);
T(236) = T(68)*(T(73)*T(70)*T(235)+T(69)*T(70)*T(197)*T(71)*T(235));
T(237) = exp(y(112))*getPowerDeriv(exp(y(112)),(-params(3)),1);
T(238) = T(82)*T(70)*T(235)+T(69)*T(70)*T(199)*T(71)*T(235);
T(239) = exp(y(112))*getPowerDeriv(exp(y(112)),1+params(8),1);
T(240) = (-(params(9)*T(239)/(1+params(8))));
T(241) = getPowerDeriv(T(102),(-params(15)),1);
T(242) = params(1)*T(240)*T(241);
T(243) = (-((-(params(1)*T(91)*exp(y(20))*T(206)))/(T(28)*T(28))));
T(244) = (-((-(params(1)*T(104)*exp(y(20))*T(206)))/(T(28)*T(28))));
T(245) = T(89)*exp(y(55))*T(214);
T(246) = T(26)*T(104)+T(26)*T(104);
T(247) = (-((T(26)*T(26)*(-(T(103)*T(245)))-(-(T(91)*T(103)))*T(246))/T(226)));
T(248) = T(104)+exp(y(55))*exp(y(55))*T(214);
T(249) = exp(y(57))*getPowerDeriv(exp(y(57)),T(22),2);
T(250) = exp(y(57))*T(249);
T(251) = T(106)+T(250);
T(252) = (-(exp(y(54)*(1-params(3)))*exp(y(18)*params(3))*T(1)*T(1)*exp(T(1)*y(59))));
T(253) = (-(T(17)*T(3)*T(16)*T(12)*(1-params(11))*(1-params(3))*T(1)*T(1)*exp(T(1)*y(59))));
T(254) = T(7)*(1-params(11))*T(1)*T(1)*exp(T(1)*y(59));
T(255) = T(69)*T(70)*T(73)*(1-params(11))*T(1)*exp(T(1)*y(116));
T(256) = T(79)*(1-params(11))*(1-params(3))*T(1)*exp(T(1)*y(116));
T(257) = T(70)*T(81)*T(256)+T(71)*T(83)*T(256);
T(258) = T(84)*T(83)*T(79)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(116))+T(86)*T(81)*T(79)*(1-params(11))*params(3)*T(1)*exp(T(1)*y(116));
T(259) = getPowerDeriv(exp(y(67)-y(60)),params(5)-1,2);
T(260) = (-(T(32)*params(6)*(exp(y(67)-y(60))*T(113)+(-exp(y(67)-y(60)))*(-exp(y(67)-y(60)))*T(259))));
T(261) = exp(y(8))*params(6)*(-params(5))*exp(params(5)*(y(15)-y(60)))*(-params(5))+exp(y(10))*params(6)*(-params(5))*exp(params(5)*(y(14)-y(60)))*(-params(5));
T(262) = T(34)*y(26)*(-(T(24)*(T(148)-params(6)*(-params(5))*exp(params(5)*(y(14)-y(60)))*(-params(5)))));
T(263) = T(24)*params(6)*params(5)*(-(params(5)-1))*exp((y(14)-y(60))*(params(5)-1))*(-(params(5)-1))-T(24)*exp((-y(60)))*(exp(y(30))-y(50));
T(264) = T(34)*y(28)*T(263);
T(265) = (-(T(32)*params(6)*((-exp(y(67)-y(60)))*T(113)+exp(y(67)-y(60))*(-exp(y(67)-y(60)))*T(259))));
T(266) = params(23)*y(122)*exp(y(37))*params(6)*exp(params(5)*(y(44)-y(117)))*(-params(5))+params(23)*y(125)*(-(exp(y(37))*(-(exp(y(44))*(-exp((-y(117))))))))+params(23)*y(131)*(-(exp(y(37))*exp(y(44))*(-exp((-y(117))))));
T(267) = params(23)*y(126)*(-(exp(y(39))*(-(exp(y(43))*(-exp((-y(117))))))));
T(268) = params(23)*y(132)*(-(exp(y(39))*exp(y(43))*(-exp((-y(117))))));
T(269) = params(23)*y(122)*exp(y(39))*params(6)*exp(params(5)*(y(43)-y(117)))*(-params(5))+T(267)+T(268);
T(270) = (-(T(23)*(exp(y(105))*(-exp(y(43)-y(117)))+exp(y(43)-y(117))*y(109)-params(6)*params(5)*exp(params(5)*(y(43)-y(117)))*(-params(5)))));
T(271) = y(80)*T(270);
T(272) = params(23)*y(131)*(-(exp(y(37))*exp(y(44))*(-exp((-y(117))))))+params(23)*y(125)*(-(exp(y(37))*(-(exp(y(44))*(-exp((-y(117))))))))+params(23)*y(122)*exp(y(37))*params(6)*params(5)*exp(params(5)*(y(44)-y(117)))*(-params(5));
T(273) = (-(T(23)*(exp(y(105))*(-exp(y(43)-y(117)))+exp(y(43)-y(117))*y(109)-params(6)*exp(params(5)*(y(43)-y(117)))*(-params(5)))));
T(274) = (-exp(y(67)-y(60)))*T(113)+(-exp(y(67)-y(60)))*exp(y(67)-y(60))*T(259);
T(275) = (-(T(32)*params(6)*T(274)));
T(276) = (-(T(32)*params(6)*(exp(y(67)-y(60))*T(113)+exp(y(67)-y(60))*exp(y(67)-y(60))*T(259))));
T(277) = T(34)*(-(T(24)*exp(y(30))*exp(y(14)-y(60))));
T(278) = T(34)*(T(24)*params(6)*params(5)*exp((y(14)-y(60))*(params(5)-1))*(-(params(5)-1))-(exp(y(30))-y(50))*T(24)*(-exp((-y(60)))));
T(279) = params(23)*(-(exp(y(37))*(-(exp((-y(117)))*exp(y(44))))));
T(280) = params(23)*(-(exp(y(39))*(-(exp((-y(117)))*exp(y(43))))));
T(281) = params(23)*(-(exp(y(37))*exp((-y(117)))*exp(y(44))));
T(282) = params(23)*(-(exp(y(39))*exp((-y(117)))*exp(y(43))));

end
